/*
 * Decompiled with CFR 0.152.
 */
package dev.ArkNLA.pixelTiles;

import dev.ArkNLA.pixelTiles.PanelPaintColorFavorites;
import dev.ArkNLA.pixelTiles.PixelTilesMain;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelColorFavorites
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private ArrayList<String> arrayColorString = new ArrayList();
    private PanelPaintColorFavorites panePaint;
    private JLabel labelStatus = new JLabel("Status");
    private ArrayList<JButton> butUse = new ArrayList();
    private ArrayList<JButton> butDelete = new ArrayList();

    PanelColorFavorites() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.labelStatus);
        this.loadColorFavoritesFromFile();
        if (!this.arrayColorString.isEmpty()) {
            this.populateJPanels();
        }
        this.setVisible(true);
    }

    public void addFavorite(String fav) {
        this.arrayColorString.add(fav);
        this.saveColorFavoritesToFile();
        this.populateJPanels();
        this.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        int i = 0;
        while (i < this.butUse.size()) {
            if (source == this.butUse.get(i)) {
                String[] split = this.arrayColorString.get(i).split(", ");
                int r = 0;
                int g = 0;
                int b = 0;
                int o = 0;
                try {
                    r = Integer.parseInt(split[0]);
                    g = Integer.parseInt(split[1]);
                    b = Integer.parseInt(split[2]);
                    o = Integer.parseInt(split[3]);
                }
                catch (Exception ex) {
                    this.labelStatus.setText("ACTION: Error converting rgbo to int.");
                }
                PixelTilesMain.userColor = new Color(r, g, b, o);
                PixelTilesMain.paneColorSelect.setColorToFavorite();
            }
            ++i;
        }
        i = 0;
        while (i < this.butDelete.size()) {
            if (source == this.butDelete.get(i)) {
                this.arrayColorString.remove(i);
                this.butUse.remove(i);
                this.butDelete.remove(i);
                this.saveColorFavoritesToFile();
                this.populateJPanels();
                this.revalidate();
            }
            ++i;
        }
    }

    private void populateJPanels() {
        this.removeAll();
        int i = 0;
        while (i < this.arrayColorString.size()) {
            String[] split = this.arrayColorString.get(i).split(", ");
            int r = 0;
            int g = 0;
            int b = 0;
            int o = 0;
            try {
                r = Integer.parseInt(split[0]);
                g = Integer.parseInt(split[1]);
                b = Integer.parseInt(split[2]);
                o = Integer.parseInt(split[3]);
            }
            catch (Exception ex) {
                this.labelStatus.setText("POPULATE: Error converting rgbo to int.");
            }
            JPanel jp = new JPanel();
            this.panePaint = new PanelPaintColorFavorites(r, g, b, o);
            this.panePaint.setPreferredSize(new Dimension(50, 50));
            this.butUse.add(new JButton("Use"));
            this.butUse.get(i).addActionListener(this);
            this.butDelete.add(new JButton("Delete"));
            this.butDelete.get(i).addActionListener(this);
            jp.add(this.panePaint);
            jp.add(this.butUse.get(i));
            jp.add(this.butDelete.get(i));
            this.add(jp);
            ++i;
        }
        this.repaint();
    }

    private void loadColorFavoritesFromFile() {
        try {
            FileInputStream fis = new FileInputStream("data/PixelTilesFavColors.dat");
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.arrayColorString = (ArrayList)ois.readObject();
            ois.close();
            this.labelStatus.setText("Loaded Success.");
        }
        catch (FileNotFoundException fnf) {
            this.labelStatus.setText("Save your favorite colors here.");
        }
        catch (Exception ex) {
            this.labelStatus.setText("LOAD FILE: Error loading favorites from file.");
        }
    }

    private void saveColorFavoritesToFile() {
        try {
            File dir = new File("data/");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream("data/PixelTilesFavColors.dat");
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.arrayColorString);
            oos.close();
            this.labelStatus.setText("Save Success.");
        }
        catch (Exception ex) {
            this.labelStatus.setText("SAVE FILE: Error saving favorites to file.");
        }
    }
}

