/*
 * Decompiled with CFR 0.152.
 */
package dev.ArkNLA.pixelTiles;

import dev.ArkNLA.pixelTiles.PanelColorFavorites;
import dev.ArkNLA.pixelTiles.PixelTilesMain;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PanelColorSelect
extends JPanel
implements ActionListener,
KeyListener,
ChangeListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private int pY;
    private int intRed = 0;
    private int intGreen = 0;
    private int intBlue = 0;
    private int intOpacity = 255;
    private Color colorSelected = new Color(this.intRed, this.intGreen, this.intBlue, this.intOpacity);
    private JPanel paneNorth = new JPanel();
    private JPanel paneColorSelected = new JPanel();
    private JPanel paneColorSelectedPreview;
    private JPanel paneColorSelectedText = new JPanel();
    private JPanel paneRGB = new JPanel();
    private JPanel panePresetColors = new JPanel();
    private JLabel labelRed;
    private JLabel labelGreen;
    private JLabel labelBlue;
    private JLabel labelBrightness;
    private JLabel labelOpacity;
    private JLabel labelRGB;
    private JLabel labelHEX;
    private JTextField textRed;
    private JTextField textGreen;
    private JTextField textBlue;
    private JTextField textBrightness;
    private JTextField textOpacity;
    private JTextField textRGB;
    private JTextField textHEX;
    private JSlider slideRed;
    private JSlider slideGreen;
    private JSlider slideBlue;
    private JSlider slideBrightness;
    private JSlider slideOpacity;
    private JButton buttonRGBcopy;
    private JButton buttonHEXcopy;
    private JButton buttonSaveFavorite;
    private JButton butRed;
    private JButton butGreen;
    private JButton butBlue;
    private JButton butYellow;
    private JButton butOrange;
    private JButton butBlack;
    private JButton butGray;
    private JButton butWhite;
    private JScrollPane paneCenter = new JScrollPane();
    private PanelColorFavorites paneFavorites = new PanelColorFavorites();

    PanelColorSelect() {
        this.pY = this.getHeight();
        this.setBounds(0, 0, 100, this.pY);
        this.setLayout(new BorderLayout());
        this.paneNorth.setLayout(new BorderLayout());
        this.paneNorth.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.paneColorSelected.setLayout(new BorderLayout());
        this.paneColorSelectedText.setLayout(new GridBagLayout());
        this.paneRGB.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.paneColorSelectedPreview = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }
        };
        this.paneColorSelectedPreview.setPreferredSize(new Dimension(100, 100));
        this.paneColorSelectedPreview.setLayout(new BorderLayout());
        this.paneColorSelected.add((Component)this.paneColorSelectedPreview, "North");
        this.labelRGB = new JLabel("RGBA:");
        this.labelHEX = new JLabel("HEX:");
        this.textRGB = new JTextField(10);
        this.textRGB.setEditable(false);
        this.textHEX = new JTextField(10);
        this.textHEX.setEditable(false);
        this.buttonRGBcopy = new JButton("Copy");
        this.buttonRGBcopy.addActionListener(this);
        this.buttonHEXcopy = new JButton("Copy");
        this.buttonHEXcopy.addActionListener(this);
        c.gridy = 0;
        c.gridx = 0;
        this.paneColorSelectedText.add((Component)this.labelRGB, c);
        c.gridy = 0;
        c.gridx = 1;
        this.paneColorSelectedText.add((Component)this.textRGB, c);
        c.gridy = 0;
        c.gridx = 2;
        this.paneColorSelectedText.add((Component)this.buttonRGBcopy, c);
        c.gridy = 1;
        c.gridx = 0;
        this.paneColorSelectedText.add((Component)this.labelHEX, c);
        c.gridy = 1;
        c.gridx = 1;
        this.paneColorSelectedText.add((Component)this.textHEX, c);
        c.gridy = 1;
        c.gridx = 2;
        this.paneColorSelectedText.add((Component)this.buttonHEXcopy, c);
        this.paneColorSelected.add((Component)this.paneColorSelectedText, "South");
        this.panePresetColors.setLayout(new GridLayout());
        this.butRed = new JButton();
        this.butGreen = new JButton();
        this.butBlue = new JButton();
        this.butYellow = new JButton();
        this.butOrange = new JButton();
        this.butBlack = new JButton();
        this.butGray = new JButton();
        this.butWhite = new JButton();
        this.butRed.setPreferredSize(new Dimension(20, 20));
        this.butGreen.setPreferredSize(new Dimension(20, 20));
        this.butBlue.setPreferredSize(new Dimension(20, 20));
        this.butYellow.setPreferredSize(new Dimension(20, 20));
        this.butOrange.setPreferredSize(new Dimension(20, 20));
        this.butBlack.setPreferredSize(new Dimension(20, 20));
        this.butGray.setPreferredSize(new Dimension(20, 20));
        this.butWhite.setPreferredSize(new Dimension(20, 20));
        this.butRed.addActionListener(this);
        this.butGreen.addActionListener(this);
        this.butBlue.addActionListener(this);
        this.butYellow.addActionListener(this);
        this.butOrange.addActionListener(this);
        this.butBlack.addActionListener(this);
        this.butGray.addActionListener(this);
        this.butWhite.addActionListener(this);
        this.butRed.setBackground(Color.RED);
        this.butGreen.setBackground(Color.GREEN);
        this.butBlue.setBackground(Color.BLUE);
        this.butYellow.setBackground(Color.YELLOW);
        this.butOrange.setBackground(Color.ORANGE);
        this.butBlack.setBackground(Color.BLACK);
        this.butGray.setBackground(Color.GRAY);
        this.butWhite.setBackground(Color.WHITE);
        this.panePresetColors.add(this.butRed);
        this.panePresetColors.add(this.butGreen);
        this.panePresetColors.add(this.butBlue);
        this.panePresetColors.add(this.butYellow);
        this.panePresetColors.add(this.butOrange);
        this.panePresetColors.add(this.butBlack);
        this.panePresetColors.add(this.butGray);
        this.panePresetColors.add(this.butWhite);
        this.labelRed = new JLabel("Red:");
        this.labelRed.setHorizontalAlignment(2);
        this.textRed = new JTextField(3);
        this.textRed.addKeyListener(this);
        this.slideRed = new JSlider(0, 255, 1);
        this.slideRed.addChangeListener(this);
        c.gridy = 0;
        c.gridx = 0;
        this.paneRGB.add((Component)this.labelRed, c);
        c.gridy = 0;
        c.gridx = 1;
        this.paneRGB.add((Component)this.textRed, c);
        c.gridy = 0;
        c.gridx = 2;
        c.fill = 2;
        this.paneRGB.add((Component)this.slideRed, c);
        this.labelGreen = new JLabel("Green:");
        this.labelGreen.setHorizontalAlignment(2);
        this.textGreen = new JTextField(3);
        this.textGreen.addKeyListener(this);
        this.slideGreen = new JSlider(0, 255, 1);
        this.slideGreen.addChangeListener(this);
        c.gridy = 1;
        c.gridx = 0;
        this.paneRGB.add((Component)this.labelGreen, c);
        c.gridy = 1;
        c.gridx = 1;
        this.paneRGB.add((Component)this.textGreen, c);
        c.gridy = 1;
        c.gridx = 2;
        c.fill = 2;
        this.paneRGB.add((Component)this.slideGreen, c);
        this.labelBlue = new JLabel("Blue:");
        this.labelBlue.setHorizontalAlignment(2);
        this.textBlue = new JTextField(3);
        this.textBlue.addKeyListener(this);
        this.slideBlue = new JSlider(0, 255, 1);
        this.slideBlue.addChangeListener(this);
        c.gridy = 2;
        c.gridx = 0;
        this.paneRGB.add((Component)this.labelBlue, c);
        c.gridy = 2;
        c.gridx = 1;
        this.paneRGB.add((Component)this.textBlue, c);
        c.gridy = 2;
        c.gridx = 2;
        c.fill = 2;
        this.paneRGB.add((Component)this.slideBlue, c);
        this.labelBrightness = new JLabel("Bri.:");
        this.labelBrightness.setHorizontalAlignment(2);
        this.textBrightness = new JTextField(3);
        this.textBrightness.addKeyListener(this);
        this.slideBrightness = new JSlider(0, 255, 0);
        this.slideBrightness.addChangeListener(this);
        c.gridy = 5;
        c.gridx = 0;
        this.paneRGB.add((Component)this.labelBrightness, c);
        c.gridy = 5;
        c.gridx = 1;
        this.paneRGB.add((Component)this.textBrightness, c);
        c.gridy = 5;
        c.gridx = 2;
        c.fill = 2;
        this.paneRGB.add((Component)this.slideBrightness, c);
        this.labelOpacity = new JLabel("O:");
        this.textOpacity = new JTextField(3);
        this.textOpacity.addKeyListener(this);
        this.slideOpacity = new JSlider(0, 255, 1);
        this.slideOpacity.addChangeListener(this);
        this.buttonSaveFavorite = new JButton("Save");
        this.buttonSaveFavorite.addActionListener(this);
        c.gridy = 6;
        c.gridx = 0;
        this.paneRGB.add((Component)this.labelOpacity, c);
        c.gridy = 6;
        c.gridx = 1;
        this.paneRGB.add((Component)this.textOpacity, c);
        c.gridy = 6;
        c.gridx = 2;
        c.fill = 2;
        this.paneRGB.add((Component)this.slideOpacity, c);
        c.gridy = 7;
        c.gridx = 2;
        this.paneRGB.add((Component)this.buttonSaveFavorite, c);
        this.paneNorth.add((Component)this.paneColorSelected, "North");
        this.paneNorth.add((Component)this.panePresetColors, "Center");
        this.paneNorth.add((Component)this.paneRGB, "South");
        this.add((Component)this.paneNorth, "North");
        this.paneCenter.getViewport().add(this.paneFavorites);
        this.add((Component)this.paneCenter, "Center");
        this.slideRed.setValue(this.intRed);
        this.slideGreen.setValue(this.intGreen);
        this.slideBlue.setValue(this.intBlue);
        this.slideOpacity.setValue(this.intOpacity);
        this.slideBrightness.setValue(10);
        this.textRed.setText(String.valueOf(this.intRed));
        this.textGreen.setText(String.valueOf(this.intGreen));
        this.textBlue.setText(String.valueOf(this.intBlue));
        this.textOpacity.setText(String.valueOf(this.intOpacity));
        this.textBrightness.setText(String.valueOf(10));
        this.setSlidersAndTexts();
        this.setDrawColor();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        block19: {
            Object source;
            block18: {
                block17: {
                    block16: {
                        source = e.getSource();
                        if (source == this.textRed) {
                            try {
                                int red = Integer.parseInt(this.textRed.getText());
                                if (red >= 0 && red <= 255) {
                                    this.intRed = red;
                                }
                            }
                            catch (Exception ex) {
                                if (this.intRed >= 0 && this.intRed <= 255) break block16;
                                this.intRed = 0;
                                this.textRed.setText("0");
                            }
                        }
                    }
                    if (source == this.textGreen) {
                        try {
                            int green = Integer.parseInt(this.textGreen.getText());
                            if (green >= 0 && green <= 255) {
                                this.intGreen = green;
                            }
                        }
                        catch (Exception ex) {
                            if (this.intGreen >= 0 && this.intGreen <= 255) break block17;
                            this.intGreen = 0;
                            this.textGreen.setText("0");
                        }
                    }
                }
                if (source == this.textBlue) {
                    try {
                        int blue = Integer.parseInt(this.textBlue.getText());
                        if (blue >= 0 && blue <= 255) {
                            this.intBlue = blue;
                        }
                    }
                    catch (Exception ex) {
                        if (this.intBlue >= 0 && this.intBlue <= 255) break block18;
                        this.intBlue = 0;
                        this.textBlue.setText("0");
                    }
                }
            }
            if (source == this.textOpacity) {
                try {
                    int opacity = Integer.parseInt(this.textOpacity.getText());
                    if (opacity >= 0 && opacity <= 255) {
                        this.intOpacity = opacity;
                    }
                }
                catch (Exception ex) {
                    if (this.intOpacity >= 0 && this.intOpacity <= 255) break block19;
                    this.intOpacity = 255;
                    this.textOpacity.setText("255");
                }
            }
        }
        this.setSlidersAndTexts();
        this.setDrawColor();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Clipboard clipboard;
        StringSelection selection;
        Object source = e.getSource();
        if (source == this.buttonRGBcopy) {
            selection = new StringSelection(this.textRGB.getText());
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
        }
        if (source == this.buttonHEXcopy) {
            selection = new StringSelection(this.textHEX.getText());
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
        }
        if (source == this.butRed) {
            this.intRed = Color.red.getRed();
            this.intGreen = Color.red.getGreen();
            this.intBlue = Color.red.getBlue();
            this.setSlidersAndTexts();
            this.setDrawColor();
        }
        if (source == this.butGreen) {
            this.intRed = Color.green.getRed();
            this.intGreen = Color.green.getGreen();
            this.intBlue = Color.green.getBlue();
            this.setSlidersAndTexts();
            this.setDrawColor();
        }
        if (source == this.butBlue) {
            this.intRed = Color.blue.getRed();
            this.intGreen = Color.blue.getGreen();
            this.intBlue = Color.blue.getBlue();
            this.setSlidersAndTexts();
            this.setDrawColor();
        }
        if (source == this.butYellow) {
            this.intRed = Color.yellow.getRed();
            this.intGreen = Color.yellow.getGreen();
            this.intBlue = Color.yellow.getBlue();
            this.setSlidersAndTexts();
            this.setDrawColor();
        }
        if (source == this.butOrange) {
            this.intRed = Color.orange.getRed();
            this.intGreen = Color.orange.getGreen();
            this.intBlue = Color.orange.getBlue();
            this.setSlidersAndTexts();
            this.setDrawColor();
        }
        if (source == this.butBlack) {
            this.intRed = Color.black.getRed();
            this.intGreen = Color.black.getGreen();
            this.intBlue = Color.black.getBlue();
            this.setSlidersAndTexts();
            this.setDrawColor();
        }
        if (source == this.butGray) {
            this.intRed = Color.gray.getRed();
            this.intGreen = Color.gray.getGreen();
            this.intBlue = Color.gray.getBlue();
            this.setSlidersAndTexts();
            this.setDrawColor();
        }
        if (source == this.butWhite) {
            this.intRed = Color.white.getRed();
            this.intGreen = Color.white.getGreen();
            this.intBlue = Color.white.getBlue();
            this.setSlidersAndTexts();
            this.setDrawColor();
        }
        if (source == this.buttonSaveFavorite) {
            this.paneFavorites.addFavorite(String.valueOf(this.intRed) + ", " + this.intGreen + ", " + this.intBlue + ", " + this.intOpacity);
            this.paneFavorites.repaint();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int v;
        Object source = e.getSource();
        if (source == this.slideRed) {
            this.intRed = v = this.slideRed.getValue();
            this.textRed.setText(String.valueOf(v));
        }
        if (source == this.slideGreen) {
            this.intGreen = v = this.slideGreen.getValue();
            this.textGreen.setText(String.valueOf(v));
        }
        if (source == this.slideBlue) {
            this.intBlue = v = this.slideBlue.getValue();
            this.textBlue.setText(String.valueOf(v));
        }
        if (source == this.slideOpacity) {
            this.intOpacity = v = this.slideOpacity.getValue();
            this.textOpacity.setText(String.valueOf(v));
        }
        if (source == this.slideBrightness) {
            v = this.slideBrightness.getValue();
            this.textBrightness.setText(String.valueOf(v));
            this.adjustBrightness(v);
            float brightness = (float)v * 100.0f / 255.0f / 100.0f;
            float[] hsb = Color.RGBtoHSB(this.intRed, this.intGreen, this.intBlue, null);
            hsb[2] = brightness;
            int rgb = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            this.intRed = rgb >> 16 & 0xFF;
            this.intGreen = rgb >> 8 & 0xFF;
            this.intBlue = rgb & 0xFF;
        }
        this.setSlidersAndTexts();
        this.setDrawColor();
    }

    private void setDrawColor() {
        this.paneColorSelectedPreview.setBackground(new Color(this.intRed, this.intGreen, this.intBlue, this.intOpacity));
        PixelTilesMain.userColor = this.colorSelected = new Color(this.intRed, this.intGreen, this.intBlue, this.intOpacity);
    }

    private void setSlidersAndTexts() {
        this.slideRed.setValue(this.intRed);
        this.slideGreen.setValue(this.intGreen);
        this.slideBlue.setValue(this.intBlue);
        this.textRed.setText(String.valueOf(this.intRed));
        this.textGreen.setText(String.valueOf(this.intGreen));
        this.textBlue.setText(String.valueOf(this.intBlue));
        this.textRGB.setText(String.valueOf(this.intRed) + ", " + this.intGreen + ", " + this.intBlue + ", " + this.intOpacity);
        this.textHEX.setText("#" + Integer.toHexString(this.intRed) + Integer.toHexString(this.intGreen) + Integer.toHexString(this.intBlue) + Integer.toHexString(this.intOpacity));
    }

    public void setColorToFavorite() {
        this.intRed = PixelTilesMain.userColor.getRed();
        this.intGreen = PixelTilesMain.userColor.getGreen();
        this.intBlue = PixelTilesMain.userColor.getBlue();
        this.intOpacity = PixelTilesMain.userColor.getAlpha();
        this.setSlidersAndTexts();
        this.setDrawColor();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void adjustBrightness(int v) {
        float brightness = (float)v * 100.0f / 255.0f / 100.0f;
        float[] hsb = Color.RGBtoHSB(this.intRed, this.intGreen, this.intBlue, null);
        hsb[2] = brightness;
        int rgb = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        this.intRed = rgb >> 16 & 0xFF;
        this.intGreen = rgb >> 8 & 0xFF;
        this.intBlue = rgb & 0xFF;
    }

    public void setColor(int r, int g, int b, int a) {
        this.intRed = r;
        this.intGreen = g;
        this.intBlue = b;
        this.intOpacity = a;
        this.setDrawColor();
        this.setSlidersAndTexts();
    }
}

